/*****************************************************************************
 *   pwm.h:  Header file for NXP LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2009, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2009.12.17  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#ifndef __PWM_H 
#define __PWM_H

#define PWM_CYCLE			6000			// 120=1MHz, 1200=100kHz, 50us
#define PWM_ADCOFFSET		188 			// 60 : 0.5 us  ADC 1 clk = 0.22 us
#define PWM_DEADTIME		40				// 250 nss : 20kHz PWM	PWM_DEADTIME=(-1.666667*PWM_CYCLE*PWM_CYCLE*us+30000*PWM_CYCLE*us)/1000000
#define PWM_MAX				0.98			// % max PWM 

#define PWM_MIN_F6_10	F6_10_CONST((1-PWM_MAX))// (1-max)% PWM phase not overlapping = 1 us 	
#define PWM_HALFDEADTIME	(PWM_DEADTIME/2)	

#define PWM_MATCH0_5			0x3F	/* Bit 0 through 5 */
#define PWM0_MATCHA0_ADR		0xE00C5100	
#define PWM0_MATCHDA0_ADR		0xE00C5200

#define CO_INT			(1 << 0)
#define TD_INT			(1 << 1)
#define UD_INT			(1 << 2)
#define EMGY_INT		(1 << 3)

#define CNT_ENA			(1 << 0)
#define CNT_RESET		(1 << 1) 
#define RUN_ONCE		(1 << 2)
#define SYNC_OUT_ENA	(1 << 3)
#define SYNC_SEL		(1 << 4)
#define TRANS_ENA_SEL	(1 << 5)
#define TRANS_ENA		(1 << 6)
#define UPD_ENA			(1 << 7)

extern void PWM0_Init( void );
extern void PWM0_Calc( void );
extern void PWM0_Set( void );
extern void PWM0_Start( void );
extern void PWM0_Stop( void );

#endif /* end __PWM_H */
/****************************************************************************
**                            End Of File
****************************************************************************/
